/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiSpellSlot;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class SpellSlottedScreen
extends BaseBook {
    public AbstractCaster<?> caster;
    public GuiSpellSlot selectedSlotButton;
    public int selectedSpellSlot = 0;
    public InteractionHand hand;
    public ItemStack bookStack;
    public Player player;
    public Minecraft mc;
    IPlayerCap playerCap;

    public SpellSlottedScreen(InteractionHand hand) {
        this.hand = hand;
        this.mc = Minecraft.getInstance();
        this.player = this.mc.player;
        this.playerCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)this.player);
        this.bookStack = this.player.getItemInHand(hand);
        this.caster = SpellCasterRegistry.from(this.bookStack);
        this.selectedSpellSlot = this.caster.getCurrentSlot();
    }

    @Override
    public void init() {
        super.init();
    }

    public void onBookstackUpdated(ItemStack stack) {
        this.bookStack = stack;
        this.caster = SpellCasterRegistry.from(stack);
    }

    public void initSpellSlots(Consumer<GuiSpellSlot> onSlotChanged) {
        for (int i = 0; i < this.caster.getMaxSlots(); ++i) {
            String name = this.caster.getSpellName(i);
            GuiSpellSlot slot = new GuiSpellSlot(this.bookLeft + 281, this.bookTop - 1 + 15 * (i + 1), i, name, b -> {
                GuiSpellSlot button;
                block3: {
                    block2: {
                        if (!(b instanceof GuiSpellSlot)) break block2;
                        button = (GuiSpellSlot)b;
                        if (this.selectedSpellSlot != button.slotNum) break block3;
                    }
                    return;
                }
                this.selectedSlotButton.isSelected = false;
                this.selectedSlotButton = button;
                button.isSelected = true;
                this.selectedSpellSlot = this.selectedSlotButton.slotNum;
                onSlotChanged.accept(this.selectedSlotButton);
            });
            if (i == this.selectedSpellSlot) {
                this.selectedSlotButton = slot;
                slot.isSelected = true;
            } else {
                slot.isSelected = false;
            }
            this.addRenderableWidget((GuiEventListener)slot);
        }
    }

    protected TooltipComponent getClientImageTooltip(int mouseX, int mouseY) {
        for (Renderable renderable : this.renderables) {
            AbstractWidget widget;
            if (renderable instanceof AbstractWidget && !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (AbstractWidget)renderable) || !(renderable instanceof GuiSpellSlot)) continue;
            GuiSpellSlot spellSlot = (GuiSpellSlot)renderable;
            Spell spell = this.caster.getSpell(spellSlot.slotNum);
            if (spell.isEmpty()) {
                return null;
            }
            return new SpellTooltip(spell, false);
        }
        return super.getClientImageTooltip(mouseX, mouseY);
    }
}

